* REGRESSIONS USED IN CREDIT CARD HOLDINGS RDP SECTION 6
* MARY-ALICE DOYLE
* LAST EDITED: 02 October 2018

*********
* SETUP
*********
*cd [specify filepath for working directory]
do ".\Stata files\Regression setup.do"

* drop respondents who do not own a credit card
drop if ccown==0
set more off

***********************
* Section 6.1: Optimism Bias
***********************

*winsorised version of variable, to redue impact of outliers
* p = 0.05 means I'm censoring the 5% most extreme values at each tail
winsor netbenefit1111, p(0.05) gen(netbenefitw)
winsor interest_paid, p(0.05) gen(interestw)

**********
* TABLES 3 and 4
**********

* * Net benefit
* simple regression - IR importance and reason for paying interest
reg netbenefitw i.q8e2##i.q7c if idtag==1 [pw=w1], vce(robust)
test 1.q8e2+1.q8e2#1.q7c=0
local sign_inter = sign(_b[1.q8e2] + _b[1.q8e2#1.q7c])
display "Ho: coef <=0 p-value = "ttail(r(df_r),`sign_inter'*sqrt(r(F)))
outreg2 using ".\Excel output\6.1 regressions.xls", replace adjr2 dec(2)
lincom 1.q8e2+ 1.q8e2#1.q7c

* all controls - IR importance and reason for paying interest
reg netbenefitw i.q8e2##i.q7c i.hhincq i.agebin i.educat2 i.empstatcons i.ccnum i.deposits if idtag==1 [pw=w1], vce(robust)
test 1.q8e2+1.q8e2#1.q7c=0
local sign_inter = sign(_b[1.q8e2] + _b[1.q8e2#1.q7c])
display "Ho: coef <=0 p-value = "ttail(r(df_r),`sign_inter'*sqrt(r(F)))
outreg2 using ".\Excel output\6.1 regressions.xls", append adjr2  dec(2)
lincom 1.q8e2+ 1.q8e2#1.q7c

* * Interest paid
* simple regression - IR importance and reason for paying interest
reg interestw i.q8e2##i.q7c if idtag==1 [pw=w1], vce(robust)
test 1.q8e2+1.q8e2#1.q7c=0
local sign_inter = sign(_b[1.q8e2] + _b[1.q8e2#1.q7c])
display "Ho: coef >0 p-value = "ttail(r(df_r),sqrt(r(F)))
outreg2 using ".\Excel output\6.1 regressions.xls", append adjr2  dec(2)
lincom 1.q8e2+ 1.q8e2#1.q7c


* all controls - IR importance and reason for paying interest
reg interestw i.q8e2##i.q7c i.hhincq i.agebin i.educat2 i.empstatcons i.ccnum i.deposits if idtag==1 [pw=w1], vce(robust)
test 1.q8e2+1.q8e2#1.q7c=0
local sign_inter = sign(_b[1.q8e2] + _b[1.q8e2#1.q7c])
display "Ho: coef <=0 p-value = "ttail(r(df_r),sqrt(r(F)))
outreg2 using ".\Excel output\6.1 regressions.xls", append adjr2  dec(2)
lincom 1.q8e2+ 1.q8e2#1.q7c


**********
* FIGURE 8: Considered interst rate in card choice
**********
tablecol q7c q8e2 if idtag==1 [pw=w1], rowpct nofreq
quietly: tabout q7c q8e2 if idtag==1 [aw=w1] using ".\Excel output\6 descriptives.xls", replace f(4) c(row) clab(graph8)

**********
* FIGURE 9: credit card interest rate by whether paid interest
**********
egen interestratebins = cut(ccmainrate), at(8(3)25)
replace interestratebins = 20 if ccmainrate>20 & ccmainrate<25
tablecol interestratebins q7b if idtag==1 [pw=w1], colpct nofreq
quietly: tabout interestratebins q7b if idtag==1 [aw=w1] using ".\Excel output\6 descriptives.xls", append f(4) c(col) clab(graph9)

table q7c if idtag==1 & ccown==1 & ccmainrate!=-5 [pw=w1], c(median ccmainrate)

**********
* TABLE 2: Cardholders paying interest
**********
* Background:
* What share of people with higher-rate cards ended up paying interest?
* define cutoff as 15%
gen lowrate = 0 if ccmainrate!=-5
replace lowrate = 1 if ccmainrate!=-5 & ccmainrate<15

tablecol q8e2 lowrate if idtag==1 [pw=w1], rowpct nofreq
tablecol lowrate q7b  if idtag==1 [pw=w1], rowpct nofreq

* Of the people on lower-rate cards, 57% ended up paying interest, 41% did not
* Of the people on higher-rate cards, 30% ended up paying interest, 70% did not

* TABLE 2 DATA: overall pct of this table:
tablecol q8e2 q7b if idtag==1 [pw=w1]
quietly: tabout q8e2 q7b if idtag==1 [aw=w1] using ".\Excel output\6 descriptives.xls", append f(4) clab(table2) 

* Of the people who did not consider the interest rate, 30 per cent ended up paying interest. 
* Of those who considered the interest rate, 44 per cent didn't pay interest



***********************
* Section 6.2: Bounded rationality
***********************
* compare determinants of net benefit to determinants of perceived monetary benefit
* create variable = 0 if respondent believes they break even or lose out, =1 
//if they believe they benefit from their credit card
gen perceivedbenefit = 0
replace perceivedbenefit = 1 if q8g==1

* For respondents who make a loss:
* create a variable = 1 if respondent is losing but believes they are gaining, 
* =0 if losing and believes they are losing or breaking even
* (missing if net benefit >-50)
gen losing = 0 if netbenefit1111<=-50
replace losing = 1 if netbenefit1111<=-50 & inlist(q8g,1)
replace losing = . if netbenefit1111==.

**********
* TABLE 5: Perceived and actual net monetary benefit
**********
tablecol q8g netdummy if idtag==1 [pw=w1], overall
quietly: tabout q8g netdummy if idtag==1 [aw=w1] using ".\Excel output\6 descriptives.xls", append f(4) clab(table5)

**********
* TABLE 6:  Regression results
**********
probit losing i.type if idtag==1  [pw=w1]
margins, dydx(_all) post
outreg2 using ".\Excel output\6.2 probit.xls", replace  dec(2)
probit losing i.type i.hhincq i.agebin i.deposit i.empstatcons i.educat2 i.ccnum if idtag==1 [pw=w1], vce(robust)
margins, dydx(_all) post
outreg2 using ".\Excel output\6.2 probit.xls",  dec(2)


***********************
* SECTION 6.3: Present bias
***********************

**********
* FIGURE 10: Signed up to card with a special offer
**********
table q8b q8a idtag if idtag==1 & ccown==1 [pw=w1]
quietly: tabout q8b q8a if idtag==1 [aw=w1] using ".\Excel output\6 descriptives.xls", append f(4) clab(graph10)

**********
* FIGURE 11: Net monetary benefit by sign-up
**********
table q8b idtag if idtag==1 & ccown==1 [pw=w1], c(mean netbenefit1111 median netbenefit1111)
quietly: tabout q8b if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\6 descriptives.xls", sum append f(4) c(mean netbenefit1111 median netbenefit1111) clab(graph11)

**********
* TABLE 7
**********

* 
* Do people get 'stuck' in inappropriate cards from sign-up offers? 
* simple regression - sign-up behaviour without controls (not in table)
reg netbenefit1111 i.q8b if idtag==1 [pw=w1], vce(robust)
reg rewards_annual i.q8b if idtag==1 [pw=w1], vce(robust)
reg annualfee i.q8b if idtag==1 [pw=w1], vce(robust)
reg interest_paid i.q8b if idtag==1 [pw=w1], vce(robust)


* all controls - sign-up behaviour
reg netbenefit1111 i.q8b i.hhincq i.agebin i.educat2 i.empstatcons i.ccnum i.deposits if idtag==1 [pw=w1], vce(robust)
outreg2 using ".\Excel output\6.3 regressions.xls", replace adjr2  dec(2)
reg rewards_annual i.q8b i.hhincq i.agebin i.educat2 i.empstatcons i.ccnum i.deposits if idtag==1 [pw=w1], vce(robust)
outreg2 using ".\Excel output\6.3 regressions.xls", append adjr2  dec(2)
reg annualfee i.q8b i.hhincq i.agebin i.educat2 i.empstatcons i.ccnum i.deposits if idtag==1 [pw=w1], vce(robust)
outreg2 using ".\Excel output\6.3 regressions.xls", append adjr2  dec(2)
reg interest_paid i.q8b i.hhincq i.agebin i.educat2 i.empstatcons i.ccnum i.deposits if idtag==1 [pw=w1], vce(robust)
outreg2 using ".\Excel output\6.3 regressions.xls", append adjr2  dec(2)


* Ok, so it looks like the people who respond to special offers are actually better off on average. 
* Seems like it's because offers are targeted at high-wealth/income consumers
table q8b if idtag==1 [pw=w1], c(median annualspend) row

*****
* FIGURE 12
*****
tablecol q8a hhincq if idtag==1 [pw=w1], colpct nofreq row
quietly: tabout q8a hhincq if idtag==1 & ccown==1 [aw=w1] using ".\Excel output\6 descriptives.xls", append f(4) c(col) clab(graph12)


